//
//  MCToolbarRegistry.h
//  MCApplication
//
//  Created by Ali Lalani on 6/18/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCToolbar;

@interface MCToolbarRegistry : NSObject {
	NSMutableDictionary *_toolbarItems;
	NSMutableDictionary *_toolbarConfigurations;
	NSMutableArray *_toolbars;
}
+ (MCToolbarRegistry *)defaultRegistry;

#pragma mark SetupAndManagement
- (MCToolbar *)copyOfToolbarForIdentifier:(NSString *)anIdentifier;
- (void)removeToolbar:(MCToolbar *)aToolbar;
- (NSToolbarItem *)createItemForIdentifier:(NSString *)ident inToolbar:(NSToolbar *)aToolbar;

#pragma mark Localization
- (NSString *)localizedString:(NSString *)aString forConfiguration:(NSDictionary *)conf;
- (NSImage *)imageForConfiguration:(NSDictionary *)conf;

#pragma mark Registration
- (void)registerToolbarConfiguration:(NSDictionary *)conf forIdentifier:(NSString *)ident;
- (void)registerToolbarConfigurations:(NSArray *)configs;
- (void)registerToolbarItem:(NSDictionary *)conf forIdentifier:(NSString *)ident;
- (void)registerToolbarItems:(NSArray *)configs;

#pragma mark Accessors
- (NSMutableDictionary *)toolbarItems;
- (void)setToolbarItems:(NSMutableDictionary *)aToolbarItems;
- (NSMutableDictionary *)toolbarConfigurations;
- (void)setToolbarConfigurations:(NSMutableDictionary *)aToolbarConfigurations;
- (NSMutableArray *)toolbars;
- (void)setToolbars:(NSMutableArray *)aToolbars;
@end
